<?php declare(strict_types=1);


namespace Newland\Toubiz\Api\Service\Toubiz\ApiV1\ObjectAdapter;

class ArticleBasedAddressAdapter extends AddressAdapter
{
    /** @var array */
    protected $article;

    public function __construct(array $article, array $address)
    {
        $this->article = $article;
        parent::__construct($address);
    }


    public function getLatitude(): ?float
    {
        return $this->article['point']['latitude']
            ?? $this->article['area']['latitude']
            ?? null;
    }

    public function getLongitude(): ?float
    {
        return $this->article['point']['longitude']
            ?? $this->article['area']['longitude']
            ?? null;
    }

    public function getEmailAddress(): ?string
    {
        return $this->article['emails'][0]['email'] ?? null;
    }

    public function getWebsiteAddress(): ?string
    {
        return ($this->article['contactInformation']['website'] ?? null) ?: null;
    }

    public function getFirstName(): ?string
    {
        return ($this->article['contactInformation']['contactPersonFirstName'] ?? null) ?: null;
    }

    public function getLastName(): ?string
    {
        return ($this->article['contactInformation']['contactPersonLastName'] ?? null) ?: null;
    }

    public function getPhoneNumber(): ?string
    {
        foreach ($this->article['phoneNumbers'] ?? [ ] as $number) {
            if ($number['type'] === 'phone') {
                return $number['iso5008'];
            }
        }
        return null;
    }

    public function getFaxNumber(): ?string
    {
        foreach ($this->article['phoneNumbers'] ?? [ ] as $number) {
            if ($number['type'] === 'fax') {
                return $number['iso5008'];
            }
        }
        return null;
    }
}
