<?php
namespace Newland\Toubiz\Api\Service;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Service factory.
 *
 * Instantiates the correct service version based on the given name.
 */
class ServiceFactory
{
    /** @var array */
    protected static $mocks = [];

    /**
     * @api
     * @param string $name
     * @param string|null $baseUri
     * @return AbstractService
     */
    public static function get(string $name, string $baseUri = null): AbstractService
    {
        $namespaced = str_replace('/', '\\', $name);
        $className = '\\Newland\\Toubiz\\Api\\Service\\' . $namespaced . 'Service';
        return static::$mocks[$name] ?? new $className($baseUri);
    }

    public static function mock(string $name, AbstractService $instance): void
    {
        static::$mocks[$name] = $instance;
    }

    public static function resetMocks(): void
    {
        static::$mocks = [];
    }
}
