<?php declare(strict_types=1);

namespace Newland\ToubizApi\Tests\Unit\Service\Tportal\ObjectAdapter;

use Newland\Toubiz\Api\Service\Tportal\ObjectAdapter\PackageAdapter;
use PHPUnit\Framework\TestCase;

class PackageAdapterTest extends TestCase
{
    public function testImageUrlProtocol(): void
    {
        $offer = new PackageAdapter(
            [
                'package' => [
                    'previewImageURL' => 'http://cdn.tomas-travel.com/fit/repository/FIT00020070101290346/GER00020060004955376_FIT00020070020127258FIT00020070020127486FIT00020070020127491FIT00020070311603528/FIT00020070101291178_sized_430_0.jpg',
                ],
            ]
        );

        $this->assertEquals(
            'https://cdn.tomas-travel.com/fit/repository/FIT00020070101290346/GER00020060004955376_FIT00020070020127258FIT00020070020127486FIT00020070020127491FIT00020070311603528/FIT00020070101291178_sized_430_0.jpg',
            $offer->getMedia()[0]->getSourceUri()
        );
    }

    public function testEmptyPreviewImage(): void
    {
        $offer = new PackageAdapter([ 'package' => [], ]);
        $this->assertCount(0, $offer->getMedia());
    }

    public function testUsesFullsizePreviewImageIfAvailable(): void
    {
        $offer = new PackageAdapter(
            [
                'package' => [
                    'previewImageURL' => 'http://test.com/small-image.png',
                ],
                'serviceData' => [
                    'multimediaURLs' => [
                        [
                            'url' => 'http://test.com/large-image.png',
                            'type' => [ 'value' => 'Preview' ],
                        ],
                    ],
                ],
            ]
        );

        $this->assertEquals('https://test.com/large-image.png', $offer->getMedia()[0]->getSourceUri());
    }

    public function testUsesCroppedPreviewImageIfNoFullsizeImageAvailable(): void
    {
        $offer = new PackageAdapter(
            [
                'package' => [
                    'previewImageURL' => 'http://test.com/small-image.png',
                ],
                'serviceData' => [
                    'multimediaURLs' => [
                        [
                            'url' => 'http://test.com/gallery-image.png',
                            'type' => [ 'value' => 'Gallery' ],
                        ],
                    ],
                ],
            ]
        );

        $this->assertEquals('https://test.com/small-image.png', $offer->getMedia()[0]->getSourceUri());
    }



    public function testIgnoresMediaWithEmptySourceUri(): void
    {
        $adapter = new PackageAdapter(
            [
                'serviceData' => [
                    'multimediaURLs' => [
                        [
                            'type' => [ 'value' => 'Preview' ],
                            'ID' => 'test',
                            'url' => '',
                        ],
                        [
                            'type' => [ 'value' => 'Preview' ],
                            'ID' => 'test',
                            'url' => 'https://placehold.it/500x500',
                        ],
                    ],
                ],
            ]
        );

        $this->assertCount(1, $adapter->getMedia());
        $this->assertEquals('https://placehold.it/500x500', $adapter->getMedia()[0]->getSourceUri());
    }

}
