<?php
namespace Newland\Toubiz\Api\Service;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

trait WithCacheProperty
{
    /**
     * @var array
     */
    protected $cache = [];

    /**
     * @return mixed
     */
    protected function cache(string $cacheName, callable $block)
    {
        if (($this->cache[$cacheName] ?? null) !== null) {
            return $this->cache[$cacheName];
        }

        $cacheItem = $block();

        $this->cache[$cacheName] = $cacheItem;

        return $cacheItem;
    }
}
