<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Service\Toubiz\ApiV1\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\Article\ExternalIdSelector;
use Newland\Toubiz\Api\ObjectAdapter\Concern\ExternalIdType;

trait WithCitySelectors
{
    /**
     * @inheritDoc
     */
    public function getCitySelectors(): array
    {
        return array_map(
            static function (array $item) {
                return new ExternalIdSelector(ExternalIdType::TOUBIZ, $item['id']);
            },
            $this->object['relatedArticles']['areas'] ?? []
        );
    }
}
