<?php

namespace Newland\ToubizApi\Tests\Unit\Utility;


use DoctrineExtensions\Query\Mysql\Time;
use Newland\Toubiz\Api\Utility\TimeDelta;
use PHPUnit\Framework\TestCase;

class TimeDeltaTest extends TestCase
{


    /**
     * @dataProvider provideFormats
     * @param string $format
     * @param array $attributes
     * @throws \Exception
     */
    public function testAllowsCreationFromMultipleFormats(string $format, array $attributes): void
    {
        $delta = TimeDelta::create($format);
        foreach ($attributes as $key => $value) {
            $this->assertEquals($value, $delta->{$key});
        }
    }

    public function provideFormats(): array
    {
        return [
            [ 'PT1H', [ 'h' => 1 ] ],
            [ 'PT1h', [ 'h' => 1 ] ],
            [ '1h', [ 'h' => 1 ] ],
            [ '1 day', [ 'd' => 1 ] ],
            [ '2 days', [ 'd' => 2 ] ],
            [ '12 hours', [ 'h' => 12 ] ],
            [ '17h', [ 'h' => 17 ] ],
        ];
    }

    /**
     * @dataProvider provideSeconds
     * @param TimeDelta $delta
     * @param int $seconds
     */
    public function testGetsSecondsForInterval(TimeDelta $delta, int $seconds): void
    {
        $this->assertEquals($seconds, $delta->asSeconds());
    }


    public function provideSeconds(): array
    {
        return [
            [ new TimeDelta('PT5S'), 5 ],
            [ new TimeDelta('PT7M'), 420 ],
            [ new TimeDelta('PT9H'), 32400 ],
            [ new TimeDelta('P2D'), 172800 ],
        ];
    }

}
