<?php
namespace Newland\Toubiz\Api\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\Concern\TransportationFacilityConstants;

/**
 * Transportation facility adapter interface.
 *
 * Defines the interface for transportations facility adapters
 * representing e.g. a ski lift.
 */
interface TransportationFacilityAdapterInterface extends ObjectAdapterInterface, TransportationFacilityConstants
{
    /**
     * Returns the name.
     *
     * @return string
     */
    public function getName();

    /**
     * Returns the region.
     *
     * @return string
     */
    public function getRegion();

    /**
     * Returns the type.
     *
     * @return integer
     */
    public function getType();

    /**
     * Returns the status.
     *
     * @return integer
     */
    public function getStatus();

    /**
     * Returns the length in meters.
     *
     * @return integer
     */
    public function getLength();

    /**
     * Returns the travelling time in seconds.
     *
     * @return integer
     */
    public function getTravelTime();

    /**
     * Returns a DateTime object of the last update of this record.
     *
     * @return \DateTime
     */
    public function getUpdatedAt();
}
