<?php
namespace Newland\Toubiz\Api\Service\Tportal\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\MediumAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\Concern\MediumConstants;
use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\Utility\UrlUtility;

/**
 * Medium adapter.
 */
class MediumAdapter extends AbstractObjectAdapter implements MediumAdapterInterface
{
    public function getExternalId(): string
    {
        return strip_tags((string) $this->object['ID']);
    }

    public function getSourceUri(): string
    {
        return (string) UrlUtility::forceHttps($this->object['url'] ?? null);
    }

    public function getCopyright(): ?string
    {
        $copyright = $this->object['copyrightHolder'] ?? null;
        return $copyright ? strip_tags($copyright) : null;
    }

    public function getTitle(): ?string
    {
        return $this->object['comment'] ?? null;
    }

    public function getType(): string
    {
        return MediumConstants::TYPE_IMAGE;
    }

    public function getAltText(): ?string
    {
        return null;
    }

    public function getDescription(): ?string
    {
        return null;
    }
}
