<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Service\Toubiz\ApiV1\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\AwardAdapterInterface;

class AwardAdapter extends AbstractObjectAdapter implements AwardAdapterInterface
{

    public function getValue(): ?float
    {
        $value = $this->object['awardBlueprint']['value'] ?? null;
        return $value ? (float) $value : null;
    }

    public function getName(): string
    {
        return $this->object['awardBlueprint']['title'];
    }

    public function getDescription(): ?string
    {
        return $this->object['awardBlueprint']['description'] ?? null;
    }

    public function getIconName(): string
    {
        $icon = trim($this->object['awardSet']['icon'] ?? '');
        return empty($icon) ? 'star' : $icon;
    }

    public function getImage(): ?string
    {
        return $this->object['awardBlueprint']['image']['url'] ?? null;
    }

    public function getExternalId(): string
    {
        return $this->object['awardBlueprint']['id'];
    }

    public function getShowInList(): bool
    {
        return $this->object['awardSet']['showInList'] ?? false;
    }
}
