<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\EventApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\MediumAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\Concern\MediumConstants;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;
use function Safe\preg_match;

/**
 * Medium adapter.
 */
class MediumAdapter extends AbstractLegacyObjectAdapter implements MediumAdapterInterface
{
    public function getExternalId(): string
    {
        return strip_tags((string) $this->object['multimediaTypeID']);
    }

    public function getSourceUri(): string
    {
        foreach ([ 'url_big', 'url', 'url_preview', 'url_thumb' ] as $field) {
            $url = strip_tags((string) ($this->object[$field] ?? ''));
            if ($this->isValidUrl($url)) {
                return $url;
            }
        }

        return '#';
    }

    private function isValidUrl(string $url): bool
    {
        if (trim($url) === '') {
            return false;
        }

        return (bool) preg_match('/^https?:\/\//', $url);
    }

    public function getCopyright(): ?string
    {
        $copyright = $this->object['copyright'] ?? null;
        return $copyright ? strip_tags((string) $copyright) : null;
    }

    public function getTitle(): ?string
    {
        $title = $this->object['text'] ?? null;
        return $title ? strip_tags((string) $title) : null;
    }

    public function getType(): string
    {
        return MediumConstants::TYPE_IMAGE;
    }

    public function getAltText(): ?string
    {
        return null;
    }

    public function getDescription(): ?string
    {
        return null;
    }
}
