<?php declare(strict_types=1);


namespace Newland\Toubiz\Api\Service\Toubiz\ApiV1\ObjectAdapter;

class MainAddressAdapter extends AddressAdapter
{
    /** @var array */
    protected $article;

    public function __construct(array $article)
    {
        $this->article = $article;
        parent::__construct($article['mainAddress']);
    }


    public function getLatitude(): ?float
    {
        return $this->article['point']['latitude']
            ?? $this->article['area']['latitude']
            ?? null;
    }

    public function getLongitude(): ?float
    {
        return $this->article['point']['longitude']
            ?? $this->article['area']['longitude']
            ?? null;
    }

    public function getEmailAddress(): ?string
    {
        return $this->article['emails'][0]['email'] ?? null;
    }

    public function getPhoneNumber(): ?string
    {
        $numbers = array_filter($this->article['phoneNumbers'] ?? [], function (array $number) {
            return $number['type'] === 'phone';
        });
        return $numbers[0]['iso5008'] ?? null;
    }

    public function getFaxNumber(): ?string
    {
        $numbers = array_filter($this->article['phoneNumbers'] ?? [], function (array $number) {
            return $number['type'] === 'fax';
        });
        return $numbers[0]['iso5008'] ?? null;
    }
}
