<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Service\Meteogroup;

use Newland\Toubiz\Api\Service\AbstractService;
use Newland\Toubiz\Api\Service\Meteogroup\ObjectAdapters\WeatherAdapter;
use Newland\Toubiz\Api\Utility\RetryPool;
use League\Flysystem\Filesystem;
use League\Flysystem\Adapter\Ftp;

class ApiService extends AbstractService
{
    public const DEFAULT_BASE_URI = 'ftp1.meteogroup.ch';

    public function fetchForecast(callable $block): void
    {
        $path = sprintf('Homepagewetter-Prognose_%s.xml', date('Ymd'));
        $block(new WeatherAdapter($this->xmlRequest($path)));
    }

    private function xmlRequest(string $path): \SimpleXMLElement
    {
        $pool = new RetryPool(5, $this->parameters['sleepSecondsOnError'] ?? 3.0);
        $pool->setLogger($this->logger);
        $pool->setDebuggingInformation([
            'service' => str_replace('Newland\\Toubiz\\Api\\Service\\', '', static::class),
            'path' => (string) $path
        ]);

        [ $username, $password ] = explode(':', $this->apiKey);
        $filesystem = new Filesystem(new Ftp([
            'host' => $this->baseUri,
            'username' => $username,
            'password' => $password,
        ]));

        return $pool->retryOnException(function () use ($filesystem, $path) {
            $string = $filesystem->read($path);
            return new \SimpleXMLElement($string);
        });
    }
}
