<?php
namespace Newland\Toubiz\Api\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\Service\Toubiz\Brochures\ObjectAdapter\BrochureCategoryAdapter;
use Newland\Toubiz\Api\Service\Toubiz\Brochures\ObjectAdapter\BrochureExternalLinkAdapter;
use Newland\Toubiz\Api\Service\Toubiz\Brochures\ObjectAdapter\BrochureTargetAdapter;

/**
 * Brochure adapter interface.
 *
 * Defines the interface for all brochure adapters
 * representing an brochure record from Toubiz.
 */
interface BrochureAdapterInterface extends ObjectAdapterInterface
{

    /**
     *
     * Returns a DateTime object representing.
     * the date of the last change to the brochure.
     */
    public function getLastChange(): \DateTime;

    public function getTitle(): string;

    public function getDescription(): string;

    public function getType(): string;


    public function getWeight(): float;

    /**
     * Returns the flag status of the brochure.
     * This is the representations of the available quantities.
     */
    public function getFlagStatus(): int;

    public function getProspectCount(): int;

    public function getSize(): string;

    public function getAddress(): string;

    /**
     * @return string[]
     */
    public function getLocations(): array;

    /**
     * @return string[]
     */
    public function getRegion(): array;

    /**
     * @return string[]
     */
    public function getLanguages(): array;

    /**
     * @return BrochureCategoryAdapter[]
     */
    public function getCategories(): array;

    /**
     * @return BrochureTargetAdapter[]
     */
    public function getTargets(): array;

    /**
     * @return string[]
     */
    public function getImages(): array;

    /**
     * @return string[]
     */
    public function getFiles(): array;

    /**
     * @return BrochureExternalLinkAdapter[]
     */
    public function getExternalLinks(): array;
}
