<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\EventApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\EventAdapterInterface;
use Newland\Toubiz\Api\Service\LanguageAware;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

/**
 * Event adapter.
 */
class EventAdapter extends AbstractLegacyObjectAdapter implements EventAdapterInterface
{
    use LanguageAware;

    /**
     * @return string
     */
    public function getExternalId(): string
    {
        return (string) $this->object['id_event'];
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->object['name'];
    }

    /**
     * @return string HTML
     */
    public function getDescription()
    {
        $descriptionPart = $this->findInArray(
            $this->object['descriptions'],
            'descriptionTypeName',
            'description'
        );
        if ($descriptionPart) {
            return $descriptionPart['description'];
        } else {
            return '';
        }
    }

    /**
     * @return string
     */
    public function getAdditionalInformation()
    {
        $descriptionPart = $this->findInArray(
            $this->object['descriptions'],
            'descriptionTypeName',
            'event_info'
        );
        if ($descriptionPart) {
            return $descriptionPart['description'];
        } else {
            return '';
        }
    }

    /**
     * @return string HTML
     */
    public function getAdmission()
    {
        $descriptionPart = $this->findInArray(
            $this->object['descriptions'],
            'descriptionTypeName',
            'price'
        );
        if ($descriptionPart) {
            return $descriptionPart['description'];
        } else {
            return '';
        }
    }

    /**
     * @return \DateTime
     */
    public function getBeginsAt()
    {
        return $this->buildDateTimeFromStrings(
            $this->object['date_from'],
            $this->object['time_from']
        );
    }

    /**
     * @return \DateTime
     */
    public function getEndsAt()
    {
        return $this->buildDateTimeFromStrings(
            $this->object['date_to'],
            $this->object['time_to']
        );
    }

    /**
     * @return bool
     */
    public function getIsHighlight()
    {
        return (bool) $this->object['is_highlight'];
    }

    /**
     * @return bool
     */
    public function getIsTipp()
    {
        return (bool) $this->object['is_tipp'];
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return (new \DateTime($this->object['timestamp']));
    }

    /**
     * @return string|null
     */
    public function getTicketUri()
    {
        return $this->parseFromDeeplink('event_deeplink', 'deeplink');
    }

    /**
     * @return string|null
     */
    public function getTicketContact()
    {
        $ticketContact = $this->parseFromDeeplink('event_deeplink', 'deeplinkContact');

        if (empty($ticketContact)) {
            $ticketContact = $this->parseFromDeeplink('event_deeplink_contact', 'deeplinkContact');
        }

        return $ticketContact;
    }

    /**
     * @return string|null
     */
    public function getLink()
    {
        if (!empty($this->object['link']) && $this->object['link'] !== 'http://') {
            return (string) $this->object['link'];
        }
        return null;
    }

    /**
     * @return array<CategoryAdapter>
     */
    public function getCategories()
    {
        return array_map(
            function ($item) {
                return (new CategoryAdapter($item));
            },
            (array) $this->object['category']
        );
    }

    /**
     * @return array<EventTagAdapter>
     */
    public function getEventTags()
    {
        return array_map(
            function ($item) {
                return (new EventTagAdapter($item));
            },
            (array) $this->object['keywords']
        );
    }

    /**
     * @return array
     */
    public function getAttributes()
    {
        $attributes = [];

        $features = [];
        foreach ((array) $this->object['features'] as $feature) {
            $features[] = (string) $feature['feature'];
        }

        $attributes['features'] = $features;
        return $attributes;
    }

    /**
     * @return array<EventDateAdapter>
     */
    public function getEventDates()
    {
        return array_map(
            function ($item) {
                return (new EventDateAdapter($item));
            },
            (array) $this->object['dates']
        );
    }

    /**
     * @return array<MediumAdapter>
     */
    public function getMedia()
    {
        return array_map(
            function ($item) {
                return (new MediumAdapter($item));
            },
            (array) $this->object['multimedia']
        );
    }

    /**
     * @return AddressAdapter|null
     */
    public function getOrganizer()
    {
        $item = $this->findInArray(
            $this->object['address'],
            'addressTypeName',
            'organizer'
        );

        // Import without an ID is not possible.
        if ($item && $item['addressTypeID']) {
            return (new AddressAdapter($item));
        }

        return null;
    }

    /**
     * @return AddressAdapter|null
     */
    public function getLocation()
    {
        $item = $this->findInArray(
            $this->object['address'],
            'addressTypeName',
            'location'
        );

        // Import without an ID is not possible.
        if ($item && $item['addressTypeID']) {
            return (new AddressAdapter($item));
        }

        return null;
    }

    /**
     * @return string|null
     */
    public function getSourceName()
    {
        if (!empty($this->object['quelle'])) {
            return $this->object['quelle'];
        }
    }

    public function getScope(): int
    {
        return (int) $this->object['meaning'];
    }

    /**
     * @param string $deeplinkType
     * @param string $field
     * @return string|null
     */
    public function parseFromDeeplink(string $deeplinkType, string $field)
    {
        $value = null;

        $part = $this->findInArray(
            $this->object['deeplinks'],
            'deeplinkTypeName',
            $deeplinkType
        );

        if (is_array($part)) {
            $value = $part[$field] ?? null;
        }

        return $value;
    }
}
