<?php
namespace Newland\Toubiz\Api\Service\OpenWeatherMap\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

class SymbolAdapter
{
    const ICON_MAP = [
        '01' => 'sunny',
        '02' => 'mostly-sunny',
        '03' => 'cloudy',
        '04' => 'heavy-clouds',
        '09' => 'heavy-rain',
        '10' => 'rain',
        '11' => 'thunderstorm',
        '13' => 'snow',
        '50' => 'mist',
    ];

    protected $defaultName = 'na';

    public function getClass(string $icon): string
    {
        $iconId = $this->getIconIndex($icon);

        return $this->getIconName($iconId);
    }

    private function getIconIndex(string $icon): string
    {
        $iconIndex = '';
        if (preg_match('/(\d*)[dn]/', $icon, $matches)) {
            $iconIndex = $matches[1];
        }

        return $iconIndex;
    }

    private function getIconName(string $iconIndex): string
    {
        $name = $this->defaultName;
        if (array_key_exists($iconIndex, self::ICON_MAP)) {
            $name = self::ICON_MAP[$iconIndex];
        }

        return $name;
    }
}
