<?php
namespace Newland\Toubiz\Api\Service\Tportal\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\PackageAdapterInterface;

class PackageAdapter extends AbstractObjectAdapter implements PackageAdapterInterface
{

    /**
     * Returns the external id used by the API
     * to identify the record.
     *
     * @return string
     */
    public function getExternalId()
    {
        return (string) $this->object['package']['packageID'];
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return (string) $this->object['package']['packageName'];
    }

    /**
     * @return string|null
     */
    public function getPreviewImage()
    {
        return $this->object['package']['previewImageURL'];
    }

    /**
     * @return string[]
     */
    public function getBenefits(): array
    {
        $description = $this->getDescription('DESCRIPTION_INCLUDED_SERVICES');
        $document = new \DOMDocument();

        if (!$description || !$document->loadHTML($description)) {
            return [];
        }

        $benefits = [];
        foreach ($document->getElementsByTagName('li') as $listItem) {
            $benefits[] = trim($listItem->nodeValue);
        }
        return $benefits;
    }

    /**
     * @return float|null
     */
    public function getMinimumNights()
    {
        return $this->object['package']['minimumNights'];
    }

    /**
     * @return float|null
     */
    public function getStartingPrice()
    {
        $group = $this->getFeatureGroup('packageprice');
        if ($group) {
            return $group['features']['number'];
        }

        return null;
    }

    /**
     * @return string|null
     */
    public function getStartingPriceCurrency()
    {
        return 'EUR';
    }

    private function getFeatureGroup(string $externalId)
    {
        foreach ($this->object['serviceData']['featureGroups'] as $featureGroup) {
            if ($externalId === $featureGroup['features']['value']['externalID']) {
                return $featureGroup;
            }
        }
        return null;
    }

    private function getDescription(string $externalId)
    {
        foreach ($this->object['serviceData']['descriptions'] as $description) {
            if ($externalId === $description['externalID']) {
                return $description['description'];
            }
        }
        return null;
    }
}
