<?php
use \Newland\Toubiz\Api\Service\StringCleaner;

class StringCleanerTest extends \PHPUnit\Framework\TestCase
{

    public function testShouldStripWhiteSpace()
    {
        $this->assertEquals(
            '',
            (new StringCleaner())->cleanHtmlString('      ')
        );
    }

    public function testShouldStripHtmlEncodedWhiteSpace()
    {
        $this->assertEquals(
            '',
            (new StringCleaner())->cleanHtmlString('&nbsp;')
        );
    }

    public function testShouldNotStripPrintableCharacters()
    {
        $this->assertEquals(
            'test',
            (new StringCleaner())->cleanHtmlString('   test   ')
        );
    }

    public function testShouldStripEmptyTags()
    {
        $this->assertEquals(
            '',
            (new StringCleaner())->cleanHtmlString('<p> </p><p> </p>')
        );
        $this->assertEquals(
            '',
            (new StringCleaner())->cleanHtmlString('<span> </span><span> </span>')
        );
        $this->assertEquals(
            '',
            (new StringCleaner())->cleanHtmlString('<i> </i><b> </b><u> </u>')
        );
    }

    public function testShouldNotStripTagsWithPrintableCharactersInside()
    {
        $this->assertEquals(
            '<p>foobar</p>',
            (new StringCleaner())->cleanHtmlString('<p>foobar</p><p> </p>')
        );
    }

    public function testShouldNotStripWhiteSpaceBetweenWords()
    {
        $this->assertEquals(
            'foo bar',
            (new StringCleaner())->cleanHtmlString('foo bar')
        );
    }


    public function testShouldNotStripWhiteSpaceBetweenTags()
    {
        $this->assertEquals(
            '<p>Foo</p> <span>bar</span>',
            (new StringCleaner())->cleanHtmlString('<p>Foo</p> <span>bar</span>')
        );
        $this->assertEquals(
            '<p>Foo </p><span> bar</span>',
            (new StringCleaner())->cleanHtmlString('<p>Foo </p><span> bar</span>')
        );
    }

    public function testShouldNotFailForStringsContainingAmpersand()
    {
        (new StringCleaner())->cleanHtmlString('<p>Foo & Bar</p>');
        (new StringCleaner())->cleanHtmlString('<p><a href="https://www.postauto.ch/">Fahrplan Postauto</a></p>
<p>Passöffnung & Fahrplan der Postautos beachten</p>');
        $this->assertTrue(true);
    }

    public function testShouldNotFailForStringsContainingBreaks()
    {
        (new StringCleaner())->cleanHtmlString('<br/>');
        (new StringCleaner())->cleanHtmlString('<br />');
        (new StringCleaner())->cleanHtmlString('<br>');
        (new StringCleaner())->cleanHtmlString('More text<br>Random Text');
        (new StringCleaner())->cleanHtmlString('<div></div><br>Random Text');
        (new StringCleaner())->cleanHtmlString('<div><br></div>');
        (new StringCleaner())->cleanHtmlString('<br></br>');
        (new StringCleaner())->cleanHtmlString('Random Text</br>');
        $this->assertTrue(true);
    }
}
