<?php
namespace Newland\Toubiz\Api\Tests\Unit\Service\Meteotest\ObjectAdapter;

use Newland\Toubiz\Api\Service\Meteotest\ObjectAdapter\WeatherAdapter;
use PHPUnit\Framework\TestCase;

abstract class MeteoTestAdapterTestCase extends TestCase
{

    protected function weatherAdapter(string $payloadName): WeatherAdapter
    {
        $data = json_decode(
            (string) file_get_contents(__DIR__ . '/../../../../Fixtures/WeatherData/meteotest.json'),
            true
        );

        return new WeatherAdapter($payloadName, $data['payload']['mos'][$payloadName]);
    }

    public function provideAllLocationNames(): array
    {
        $data = json_decode(
            (string) file_get_contents(__DIR__ . '/../../../../Fixtures/WeatherData/meteotest.json'),
            true
        );

        return array_map(
            function(string $key) {
                return [ $key ];
            },
            array_keys($data['payload']['mos'])
        );
    }

}