<?php
namespace Newland\Toubiz\Api\Service\Tportal\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\AttributeAdapterInterface;

class AttributeAdapter extends AbstractObjectAdapter implements AttributeAdapterInterface
{
    public function __construct(string $articleExternalId, string $name, $data = null)
    {
        parent::__construct([
            'articleExternalId' => $articleExternalId,
            'name' => $name,
            'data' => $data,
        ]);
    }

    public function getName(): string
    {
        return $this->object['name'];
    }

    public function getData()
    {
        return $this->object['data'];
    }

    public function getGroupId()
    {
        return $this->getGroupIdFromName();
    }

    public function getExternalId()
    {
        return $this->object['articleExternalId'];
    }

    protected function getGroupIdFromName(): string
    {
        return 'default';
    }
}
