<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\EventApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\EventAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

/**
 * Event adapter.
 */
class EventAdapter extends AbstractLegacyObjectAdapter implements EventAdapterInterface
{
    /**
     * @return string
     */
    public function getExternalId()
    {
        return $this->object['id_event'];
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->object['name'];
    }

    /**
     * @return string HTML
     */
    public function getDescription()
    {
        $descriptionPart = $this->findInArray(
            $this->object['descriptions'],
            'descriptionTypeName',
            'description'
        );
        if ($descriptionPart) {
            return $descriptionPart['description'];
        } else {
            return '';
        }
    }

    /**
     * @return string HTML
     */
    public function getAdmission()
    {
        $descriptionPart = $this->findInArray(
            $this->object['descriptions'],
            'descriptionTypeName',
            'price'
        );
        if ($descriptionPart) {
            return $descriptionPart['description'];
        } else {
            return '';
        }
    }

    /**
     * @return \DateTime
     */
    public function getBeginsAt()
    {
        return $this->buildDateTimeFromStrings(
            $this->object['date_from'],
            $this->object['time_from']
        );
    }

    /**
     * @return \DateTime
     */
    public function getEndsAt()
    {
        return $this->buildDateTimeFromStrings(
            $this->object['date_to'],
            $this->object['time_to']
        );
    }

    /**
     * @return bool
     */
    public function getIsHighlight()
    {
        return (bool) $this->object['is_highlight'];
    }

    /**
     * @return bool
     */
    public function getIsTipp()
    {
        return (bool) $this->object['is_tipp'];
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return (new \DateTime($this->object['timestamp']));
    }

    /**
     * @return string|null
     */
    public function getTicketUri()
    {
        $part = $this->findInArray(
            $this->object['deeplinks'],
            'deeplinkTypeName',
            'event_deeplink'
        );

        if ($part) {
            return $part['deeplink'];
        }
    }

    /**
     * @return array<CategoryAdapter>
     */
    public function getCategories()
    {
        return array_map(
            function ($item) {
                return (new CategoryAdapter($item));
            },
            (array) $this->object['category']
        );
    }

    /**
     * @return array<EventTagAdapter>
     */
    public function getEventTags()
    {
        return array_map(
            function ($item) {
                return (new EventTagAdapter($item));
            },
            (array) $this->object['keywords']
        );
    }

    /**
     * @return array
     */
    public function getAttributes()
    {
        $attributes = [];

        $features = [];
        foreach ((array) $this->object['features'] as $feature) {
            $features[] = (string) $feature['feature'];
        }

        $attributes['features'] = $features;
        return $attributes;
    }

    /**
     * @return array<EventDateAdapter>
     */
    public function getEventDates()
    {
        return array_map(
            function ($item) {
                return (new EventDateAdapter($item));
            },
            (array) $this->object['dates']
        );
    }

    /**
     * @return array<MediumAdapter>
     */
    public function getMedia()
    {
        return array_map(
            function ($item) {
                return (new MediumAdapter($item));
            },
            (array) $this->object['multimedia']
        );
    }

    /**
     * @return AddressAdapter|null
     */
    public function getOrganizer()
    {
        $item = $this->findInArray(
            $this->object['address'],
            'addressTypeName',
            'organizer'
        );

        // Import without an ID is not possible.
        if ($item && $item['addressTypeID']) {
            return (new AddressAdapter($item));
        }

        return null;
    }

    /**
     * @return AddressAdapter|null
     */
    public function getLocation()
    {
        $item = $this->findInArray(
            $this->object['address'],
            'addressTypeName',
            'location'
        );

        // Import without an ID is not possible.
        if ($item && $item['addressTypeID']) {
            return (new AddressAdapter($item));
        }

        return null;
    }

    /**
     * @return string|null
     */
    public function getSourceName()
    {
        if (!empty($this->object['quelle'])) {
            return $this->object['quelle'];
        }
    }

    public function getScope(): int
    {
        return (int) $this->object['meaning'];
    }
}
