<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\DbService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\AddressAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

/**
 * Address adapter.
 *
 * This one is specifically for the tportal gastro endpoint.
 */
class AddressAdapter extends AbstractLegacyObjectAdapter implements AddressAdapterInterface
{
    /**
     * @return string
     */
    public function getExternalId()
    {
        // There is not really an id for this.
        return $this->object['object']['id'];
    }

    /**
     * @return string|null
     */
    public function getTitle()
    {
        return $this->object['object']['data_map']['address_title']['content'];
    }

    /**
     * @return string|null
     */
    public function getFirstName()
    {
    }

    /**
     * @return string|null
     */
    public function getLastName()
    {
    }

    /**
     * @return string|null
     */
    public function getStreet()
    {
        $value = $this->object['object']['data_map']['street']['content'];
        if (!empty($value)) {
            return $value;
        }
    }

    /**
     * @return string|null
     */
    public function getZip()
    {
        $value = $this->object['object']['data_map']['zip']['content'];
        if (!empty($value)) {
            return $value;
        }
    }

    /**
     * @return string|null
     */
    public function getCity()
    {
        $value = $this->object['city'] ?? null;
        if ($value) {
            return $value;
        }

        $value = $this->object['object']['data_map']['city']['content'];
        if (!empty($value)) {
            return $value;
        }

        return null;
    }

    /**
     * @return string
     */
    public function getPhoneNumber()
    {
        return $this->object['object']['data_map']['phone']['content'];
    }

    /**
     * @return string
     */
    public function getEmailAddress()
    {
        return $this->object['object']['data_map']['email']['content'];
    }

    /**
     * @return string|null
     */
    public function getWebsiteAddress()
    {
        $url = $this->object['object']['data_map']['url']['content'];

        // The API also returns 'http://' or 'https://' as address, which should be blank.
        if (strlen($url) <= 8) {
            return null;
        }

        // The protocol may also be missing.
        if (substr($url, 0, 4) !== 'http') {
            $url = 'http://' . $url;
        }

        return $url;
    }

    /**
     * @return float|null
     */
    public function getLatitude()
    {
        if (strpos($this->object['geo'], '#') !== false) {
            list($latitude) = explode('#', $this->object['geo']);
            return ((float) $latitude) ?: null;
        }

        return null;
    }

    /**
     * @return float|null
     */
    public function getLongitude()
    {
        if (strpos($this->object['geo'], '#') !== false) {
            list(, $longitude) = explode('#', $this->object['geo']);
            return ((float) $longitude) ?: null;
        }
        return null;
    }

    public function isLookup(): bool
    {
        return true;
    }
}
