<?php
namespace Newland\Toubiz\Api\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Address adapter interface.
 *
 * Defines the interface for all address adapters
 * representing an address record attached to another record.
 */
interface AddressAdapterInterface extends ObjectAdapterInterface
{
    /**
     * Returns the title of the address,
     * which can e.g. be a building name.
     *
     * @return string
     */
    public function getTitle();

    /**
     * Returns the first name of a person-based address.
     *
     * @return string
     */
    public function getFirstName();

    /**
     * Returns the last name of a person-based address.
     *
     * @return string
     */
    public function getLastName();

    /**
     * Returns the street.
     *
     * @return string
     */
    public function getStreet();

    /**
     * Returns the zip code.
     *
     * @return string
     */
    public function getZip();

    /**
     * Returns the city.
     *
     * @return string
     */
    public function getCity();

    /**
     * Returns the phone number.
     *
     * @return string
     */
    public function getPhoneNumber();

    /**
     * Returns the email address.
     *
     * @return string
     */
    public function getEmailAddress();

    /**
     * Returns the website address.
     *
     * @return string
     */
    public function getWebsiteAddress();

    /**
     * @return float|null
     */
    public function getLatitude();

    /**
     * @return float|null
     */
    public function getLongitude();

    /**
     * Lookups are automatically calculated addresses based on coordinates, rather than manual data.
     *
     * @return bool
     */
    public function isLookup(): bool;
}
