<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\DirectMarketerApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\ArticleAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

/**
 * Direct marketer adapter.
 *
 * This represents an Article with mapping for the Toubiz specific direct marketer.
 */
class DirectMarketerAdapter extends AbstractLegacyObjectAdapter implements ArticleAdapterInterface
{
    /**
     * @return int
     */
    public function getMainType()
    {
        return ArticleConstants::TYPE_DIRECT_MARKETER;
    }

    /**
     * @return string
     */
    public function getExternalId()
    {
        return $this->object['remote_id'];
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->object['name'];
    }

    /**
     * @return string|null
     */
    public function getAbstract()
    {
        return null;
    }

    /**
     * @return string|null
     */
    public function getDescription()
    {
        $description = null;
        if (!is_array($this->object['description'])) {
            return $description;
        }
        if (array_key_exists('direkt', $this->object['description'])) {
            $value = $this->object['description']['direkt']['text'];
        } elseif (array_key_exists('direkt_event', $this->object['description'])) {
            $value = $this->object['description']['direkt_event']['text'];
        }

        if (!empty($value)) {
            $description = $value;
        }

        return $description;
    }

    /**
     * @return string
     */
    public function getStreet()
    {
        return $this->object['address']['street'];
    }

    /**
     * @return string
     */
    public function getZip()
    {
        return $this->object['address']['zip'];
    }

    /**
     * @return string
     */
    public function getCity()
    {
        return $this->object['address']['city'];
    }

    /**
     * @return string|null
     */
    public function getCountry()
    {
        return null;
    }

    /**
     * @return float
     */
    public function getLatitude()
    {
        return $this->object['location']['Latitude'];
    }

    /**
     * @return float
     */
    public function getLongitude()
    {
        return $this->object['location']['Longitude'];
    }

    /**
     * @return array<AddressAdapter>
     */
    public function getAddresses()
    {
        $address = new AddressAdapter($this->object);
        return [ $address ];
    }

    /**
     * @return array<CategoryAdapter>
     */
    public function getCategories()
    {
        $category = new CategoryAdapter($this->object['main_category']);
        return [ $category ];
    }

    /**
     * @return array<MediumAdapter>
     */
    public function getMedia()
    {
        if (!is_array($this->object['images'])) {
            return [];
        }

        if (array_key_exists('all', $this->object['images'])) {
            // Some images are nested inside 'all'.
            $items = $this->object['images']['all'];
        } else {
            // ... and some are not inside 'all'.
            $items = $items = $this->object['images'];
        }

        $media = [];
        foreach ($items as $image) {
            $media[] = (new MediumAdapter($image));
        }
        return $media;
    }

    public function hasAttributes()
    {
        return false;
    }

    /**
     * @return array
     */
    public function getAttributes()
    {
        return [];
    }

    /**
     * @return string
     */
    public function getFacebookUri()
    {
        return '';
    }

    /**
     * @return string
     */
    public function getTwitterUri()
    {
        return '';
    }

    /**
     * @return string
     */
    public function getInstagramUri()
    {
        return '';
    }

    /**
     * @return string
     */
    public function getYoutubeUri()
    {
        return '';
    }

    /**
     * @return array
     */
    public function getFiles()
    {
        return [];
    }

    /**
     * @return string
     */
    public function getSourceName()
    {
        return $this->object['headline_quellmandant'];
    }

    /**
     * @return string|null
     */
    public function getAuthorName()
    {
        $author = null;
        if (!empty($this->object['author'])) {
            $author = $this->object['author'];
        }

        return $author;
    }

    /**
     * @return string
     */
    public function getBookingUri()
    {
        return '';
    }

    /**
     * @return string
     */
    public function getDetailUri()
    {
        return '';
    }

    /**
     * The complete opening times data.
     *
     * @return string
     */
    public function getOpeningTimes()
    {
        return (string) json_encode($this->object['opentimes']);
    }

    /**
     * Return the star classification for hotels.
     *
     * @return int
     */
    public function getStarClassification()
    {
        return 0;
    }

    /**
     * Return the average rating on a scale of 0-100
     *
     * @return int
     */
    public function getAverageRating()
    {
        return 0;
    }

    /**
     * Return the number of ratings.
     *
     * @return int
     */
    public function getNumberOfRatings()
    {
        return 0;
    }
}
