<?php
namespace Newland\Toubiz\Api\Service\Outdooractive\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\MediumAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;

/**
 * Medium adapter.
 */
class MediumAdapter extends AbstractObjectAdapter implements MediumAdapterInterface
{
    /**
     * @var string
     */
    const IMAGE_URL = 'https://www.outdooractive.com/img/800/:id/.jpg';

    /**
     * @var integer
     */
    protected $sorting;

    /**
     * @return string
     */
    public function getExternalId()
    {
        return 'outdooractive_' . (string) $this->object['id'];
    }

    /**
     * @return string
     */
    public function getSourceUri()
    {
        return str_replace(':id', (string) $this->object['id'], self::IMAGE_URL);
    }

    /**
     * @return string
     */
    public function getCopyright()
    {
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        return (string) $this->object->title;
    }

    /**
     * @return integer
     */
    public function getSorting()
    {
        return $this->sorting;
    }

    /**
     * @param int $sorting
     * @return void
     */
    public function setSorting($sorting)
    {
        $this->sorting = $sorting;
    }
}
