<?php
namespace Newland\Toubiz\Api\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Event adapter interface.
 *
 * Defines the interface for all event adapters
 * representing an event record from Toubiz.
 */
interface EventAdapterInterface extends ObjectAdapterInterface
{
    /**
     * Returns the full name of the event.
     *
     * @return string
     */
    public function getName();

    /**
     * Returns the full event description as
     * valid HTML.
     *
     * @return string HTML
     */
    public function getDescription();

    /**
     * Returns a DateTime object representing
     * the first date and time this event occurs.
     *
     * @return \DateTime
     */
    public function getBeginsAt();

    /**
     * Returns a DateTime object representing
     * the last date and time this event occurs.
     *
     * @return \DateTime
     */
    public function getEndsAt();

    /**
     * Returns the full admission and pricing text as
     * valid HTML.
     *
     * @return string HTML
     */
    public function getAdmission();

    /**
     * Returns true if the event is marked as highlight.
     *
     * @return bool
     */
    public function getIsHighlight();

    /**
     * Returns true if the event is marked as tipp.
     *
     * @return bool
     */
    public function getIsTipp();

    /**
     * Returns the URI for buying a ticket.
     *
     * @return string|null
     */
    public function getTicketUri();

    /**
     * Returns a DateTime object representing
     * the last modification time of the record.
     *
     * @return \DateTime
     */
    public function getUpdatedAt();

    /**
     * Returns assigned category records.
     *
     * @return array<CategoryAdapterInterface>
     */
    public function getCategories();

    /**
     * Returns assigned event dates.
     *
     * @return array<EventDateAdapterInterface>
     */
    public function getEventDates();

    /**
     * Returns assigned event attributes.
     *
     * @return array
     */
    public function getAttributes();

    /**
     * Returns assigned media records.
     *
     * @return array<MediumAdapterInterface>
     */
    public function getMedia();

    /**
     * Returns an address record of the event organizer.
     *
     * @return AddressAdapterInterface
     */
    public function getOrganizer();

    /**
     * Returns an address record of the event location.
     *
     * @return AddressAdapterInterface
     */
    public function getLocation();

    /**
     * Returns the name of the record source.
     *
     * @return string
     */
    public function getSourceName();

    /**
     * Return the scope of the event.
     *
     * @return int
     */
    public function getScope(): int;
}
