<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\Service\AbstractService;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\DirectMarketerApiService\DirectMarketerAdapter;

/**
 * Service for legacy Toubiz gastronomy API.
 *
 * Concrete implementation to communicate with
 * the first, "old" toubiz API returning gastronomy articles.
 */
class DirectMarketerApiService extends AbstractService
{
    /**
     * @var string Base URI of API endpoint.
     */
    const BASE_URI = 'https://api.toubiz.de/json/direkt/';

    /**
     * Fetch records.
     *
     * @param callable $block
     * @return void
     */
    public function fetchDirectMarketers(callable $block)
    {
        $offset = 0;
        $limit = 100;
        while (true) {
            $data = $this->sendRequest($offset, $limit);
            if (!$data) {
                return;
            }

            foreach ($data as $item) {
                $article = new DirectMarketerAdapter($item);
                $block($article);
            }

            $offset += $limit;
        }
    }

    /**
     * Requests data from the API.
     *
     * @param int $offset
     * @param int $limit
     * @return mixed
     */
    protected function sendRequest($offset, $limit)
    {
        $response = $this->httpClient->request(
            'GET',
            'modified.php',
            [
                'query' => [
                    'key' => $this->apiKey,
                    'modified' => 86400000000,
                    'offset' => $offset,
                    'limit' => $limit
                ]
            ]
        );
        if ($response->getStatusCode() == 200) {
            $data = json_decode($response->getBody(), true);
            if ($data['result']) {
                return $data['result']['item'];
            } else {
                return false;
            }
        } else {
            return false;
        }
    }
}
