<?php
namespace Newland\Toubiz\Api\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Attribute adapter interface.
 *
 * Defines the interface for attribute adapters
 * representing an attribute.
 */
interface AttributeAdapterInterface extends ObjectAdapterInterface
{
    /**
     * Returns the name of this attribute.
     *
     * @return string
     */
    public function getName();

    /**
     * Returns the data of the attribute.
     *
     * @return array
     */
    public function getData();

    /**
     * Returns the group id this attribute belongs to.
     *
     * @return int
     */
    public function getGroupId();

    /**
     * Return the external id of the parent article.
     *
     * @return string
     */
    public function getExternalId();
}
