<?php
namespace Newland\Toubiz\Api\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Article adapter interface.
 *
 * Defines the interface for all article adapters
 * representing an article.
 */
interface ArticleAdapterInterface extends ObjectAdapterInterface
{
    /**
     * Returns the main type of the article.
     *
     * This is used for filtering records.
     *
     * @see Concern\ArticleConstants
     * @return int
     */
    public function getMainType();

    /**
     * Returns the full name of the article.
     *
     * @return string
     */
    public function getName();

    /**
     * Returns the abstract of the article.
     *
     * @return string
     */
    public function getAbstract();

    /**
     * Returns the description of the article.
     *
     * @return string
     */
    public function getDescription();

    /**
     * Returns the street of the article.
     *
     * @return string|null
     */
    public function getStreet();

    /**
     * Returns the zip code of the article.
     *
     * @return string|null
     */
    public function getZip();

    /**
     * Returns the city of the article.
     *
     * @return string|null
     */
    public function getCity();

    /**
     * Returns the country of the article.
     *
     * @return string|null
     */
    public function getCountry();

    /**
     * Returns the latitude of the article.
     *
     * @return float
     */
    public function getLatitude();

    /**
     * Returns the longitude of the article.
     *
     * @return float
     */
    public function getLongitude();

    /**
     * Returns assigned address records.
     *
     * @return array<AddressAdapterInterface>
     */
    public function getAddresses();

    /**
     * Returns assigned category records.
     *
     * @return array<CategoryAdapterInterface>
     */
    public function getCategories();

    /**
     * Returns assigned media files.
     *
     * @return array<MediumAdapterInterface>
     */
    public function getMedia();

    /**
     * Returns assigned files.
     *
     * @return array<FileAdapterInterface>
     */
    public function getFiles();

    /**
     * Returns an array of various attributes.
     *
     * @return array<AttributeAdapter>
     */
    public function getAttributes();

    /**
     * Returns the facebook URI.
     *
     * @return string
     */
    public function getFacebookUri();

    /**
     * Returns the twitter URI.
     *
     * @return string
     */
    public function getTwitterUri();

    /**
     * Returns the instagram URI.
     *
     * @return string
     */
    public function getInstagramUri();

    /**
     * Returns the youtube URI.
     *
     * @return string
     */
    public function getYoutubeUri();

    /**
     * Returns the name of the record source.
     *
     * @return string
     */
    public function getSourceName();

    /**
     * Returns the name of the author.
     *
     * @return string
     */
    public function getAuthorName();

    /**
     * Returns the URI for an external booking page.
     *
     * @return string
     */
    public function getBookingUri();

    /**
     * Returns the URI for an external detail page.
     *
     * @return string
     */
    public function getDetailUri();

    /**
     * The complete opening times data.
     *
     * @return string|null
     */
    public function getOpeningTimes();

    /**
     * Return the star classification for hotels.
     *
     * @return int
     */
    public function getStarClassification();

    /**
     * Return the average rating on a scale of 0-100
     *
     * @return int
     */
    public function getAverageRating();

    /**
     * Return the number of ratings.
     *
     * @return int
     */
    public function getNumberOfRatings();
}
