<?php

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

namespace Newland\Toubiz\Api\ObjectAdapter\Weather;

use Newland\Toubiz\Api\ObjectAdapter\ObjectAdapterInterface;

interface DayAdapterInterface extends ObjectAdapterInterface
{
    public function getDate(): \DateTime;

    /**
     * @return HourAdapterInterface[]
     */
    public function getAllHours(): array;

    /**
     * Key hours spread over the course of a day,
     * usually 00:00, 06:00, 12:00 and 18:00.
     *
     * @return HourAdapterInterface[]
     */
    public function getMainHours(): array;

    public function getMainHoursPadded(): array;

    public function getMaximumTemperature(): int;

    public function getMinimumTemperature(): int;

    public function getSymbol(): string;

    public function hasSunshineDurationData(): bool;

    /**
     * The total amount of sunshine during the day in minutes.
     *
     * @return int
     */
    public function getSunshineDuration(): int;
}
