<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\GastronomyApiService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\AddressAdapterInterface;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

/**
 * Address adapter.
 *
 * This one is specifically for the tportal gastro endpoint.
 */
class AddressAdapter extends AbstractLegacyObjectAdapter implements AddressAdapterInterface
{
    /**
     * @return string
     */
    public function getExternalId()
    {
        // There is not really an id for this.
        return $this->object['remote_id'];
    }

    /**
     * @return string
     */
    public function getTitle()
    {
        if (!empty($this->object['address']['name'])) {
            return $this->object['address']['name'];
        }
        return $this->object['address']['Title'];
    }

    /**
     * @return string
     */
    public function getFirstName()
    {
        return $this->object['address']['firstname'];
    }

    /**
     * @return string
     */
    public function getLastName()
    {
        return $this->object['address']['lastname'];
    }

    /**
     * @return string
     */
    public function getStreet()
    {
        return $this->object['address']['street'];
    }

    /**
     * @return string|null
     */
    public function getZip()
    {
        $value = $this->object['address']['zip'];
        if (!empty($value)) {
            return $value;
        }
    }

    /**
     * @return string|null
     */
    public function getCity()
    {
        return $this->object['address']['city'];
    }

    /**
     * @return string
     */
    public function getPhoneNumber()
    {
        return $this->object['address']['phone1'];
    }

    /**
     * @return string
     */
    public function getEmailAddress()
    {
        return $this->object['address']['email'];
    }

    /**
     * @return string
     */
    public function getWebsiteAddress()
    {
        $url = $this->object['address']['internet'];

        // The API also returns 'http://' or 'https://' as address, which should be blank.
        if (strlen($url) <= 8) {
            return null;
        }

        // The protocol may also be missing.
        if (substr($url, 0, 4) !== 'http') {
            $url = 'http://' . $url;
        }

        return $url;
    }
}
