<?php
namespace Newland\Toubiz\Api\Service\OpenWeatherMap\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

class SymbolAdapter
{
    public function getClass(string $description): string
    {
        switch ($description) {
            case 'clear sky':
                $name = 'sunny';
                break;

            case 'few clouds':
                $name = 'mostly-sunny';
                break;

            case 'scattered clouds':
                $name = 'cloudy';
                break;

            case 'broken clouds':
                $name = 'heavy-clouds';
                break;

            case 'thunderstorm':
                $name = 'thunderstorm';
                break;

            case 'shower rain':
                $name = 'heavy-rain';
                break;

            case 'snow':
                $name = 'snow';
                break;

            case 'mist':
                $name = 'fog';
                break;

            case 'rain':
            case 'light rain':
            case 'moderate rain':
                $name = 'rain';
                break;

            default:
                $name = 'na';
                break;
        }

        return $name;
    }
}
