<?php

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

namespace Newland\Toubiz\Api\ObjectAdapter\Weather;

use Newland\Toubiz\Api\ObjectAdapter\ObjectAdapterInterface;

interface HourAdapterInterface extends ObjectAdapterInterface
{
    /**
     * The hour of the time in 0 - 23 format.
     *
     * @return int
     */
    public function getTime(): int;

    public function getDate(): \DateTime;

    public function getTemperature(): int;

    public function getMinimumTemperature(): int;

    public function getMaximumTemperature(): int;

    public function getSymbol(): string;
}
