<?php
namespace Newland\Toubiz\Api\Service\Weather\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\Weather\HourAdapterInterface;

abstract class AbstractDayAdapter
{
    /**
     * @var HourAdapterInterface[]
     */
    protected $hours = [];

    /**
     * Returns the symbol code for the data group.
     *
     * @return string
     */
    protected function getGeneralSymbol(): string
    {
        $count = [];
        foreach ($this->hours as $hour) {
            if ($hour->getTime() >= 8 && $hour->getTime() <= 18) {
                if (!array_key_exists($hour->getSymbol(), $count)) {
                    $count[$hour->getSymbol()] = 1;
                } else {
                    $count[$hour->getSymbol()]++;
                }
            }
        }

        return array_keys($count, max($count))[0];
    }

    protected function calculateMaximumTemperature(): int
    {
        $temperatures = [];
        foreach ($this->getHoursForCalculation() as $hourItem) {
            $temperatures[] = $hourItem->getMaximumTemperature();
        }

        return max($temperatures);
    }

    protected function calculateMinimumTemperature(): int
    {
        $temperatures = [];
        foreach ($this->getHoursForCalculation() as $hourItem) {
            $temperatures[] = $hourItem->getMinimumTemperature();
        }

        return min($temperatures);
    }

    abstract protected function calculateSunshineDuration(array $data): int;

    /**
     * @return HourAdapterInterface[]
     */
    abstract public function getMainHours(): array;

    /**
     * @return HourAdapterInterface[]
     */
    abstract public function getHoursForCalculation(): array;
}
