<?php

namespace Newland\Toubiz\Api\Service\OpenWeatherMap\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\Weather\HourAdapterInterface;

class HourAdapter implements HourAdapterInterface
{
    /**
     * @var SymbolAdapter
     */
    private $symbolAdapter;
    /**
     * @var \DateTime
     */
    private $date;
    /**
     * @var int
     */
    private $time;
    /**
     * @var int
     */
    private $temperature;
    /**
     * @var int
     */
    private $minimumTemperature;
    /**
     * @var int
     */
    private $maximumTemperature;
    /**
     * @var string
     */
    private $symbol;

    public function __construct(array $data)
    {
        $this->symbolAdapter = new SymbolAdapter();
        $this->parseData($data);
    }

    private function parseData(array $data)
    {
        $this->date = \DateTime::createFromFormat('U', $data['dt']);
        $this->time = (int)$this->date->format('G');
        $this->temperature = (int)$data['main']['temp'];
        $this->minimumTemperature = (int)$data['main']['temp_min'];
        $this->maximumTemperature = (int)$data['main']['temp_max'];
        $this->symbol = $this->symbolAdapter->getClass($data['weather'][0]['description']);
    }

    public function getDate(): \DateTime
    {
        return $this->date;
    }

    /**
     * The hour of the time in 0 - 23 format.
     *
     * @return int
     */
    public function getTime(): int
    {
        return $this->time;
    }

    public function getTemperature(): int
    {
        return $this->temperature;
    }

    public function getMinimumTemperature(): int
    {
        return $this->minimumTemperature;
    }

    public function getMaximumTemperature(): int
    {
        return $this->maximumTemperature;
    }

    public function getSymbol(): string
    {
        return $this->symbol;
    }

    public function getExternalId(): string
    {
        return '';
    }
}
