<?php

namespace Newland\Toubiz\Api\Service\Meteotest\ObjectAdapter;

class SymbolAdapter
{
    /**
     * Returns the correct icon class the meteotest symbol ids.
     *
     * @param int $id
     * @return string
     */
    public function getClass(int $id): string
    {
        switch ($id) {
            case '1':
                $name = 'sunny';
                break;

            case '2':
                $name = 'mostly-sunny';
                break;

            case '3':
                $name = 'cloudy';
                break;

            case '4':
                $name = 'heavy-clouds';
                break;

            case '5':
            case '13':
                $name = 'thunderstorm';
                break;

            case '6':
                $name = 'heavy-rain';
                break;

            case '7':
            case '9':
            case '12':
            case '15':
                $name = 'snow';
                break;

            case '8':
            case '14':
                $name = 'fog';
                break;

            case '10':
            case '11':
                $name = 'rain';
                break;

            default:
                $name = 'na';
                break;
        }

        return $name;
    }
}
