<?php
namespace Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\DbService;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\ArticleAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\Concern\ArticleConstants;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\AbstractLegacyObjectAdapter;

/**
 * Point of interest adapter.
 *
 * This represents an Article from the DB service.
 */
class PointOfInterestAdapter extends AbstractLegacyObjectAdapter implements ArticleAdapterInterface
{
    /**
     * @return int
     */
    public function getMainType()
    {
        return ArticleConstants::TYPE_ATTRACTION;
    }

    /**
     * @return string
     */
    public function getExternalId()
    {
        return $this->object['remote_id'];
    }

    /**
     * @return string
     */
    public function getName()
    {
        return substr($this->object['name'], 0, 240);
    }

    /**
     * @return string|null
     */
    public function getAbstract()
    {
        $value = $this->object['object']['data_map']['intro']['content'];
        if (!empty($value)) {
            return $value;
        }
    }

    /**
     * @return string|null
     */
    public function getDescription()
    {
        $value = $this->object['object']['data_map']['description']['content'];
        if (!empty($value)) {
            return $value;
        }
    }

    /**
     * @return string
     */
    public function getStreet()
    {
        return $this->object['object']['data_map']['street']['content'];
    }

    /**
     * @return string
     */
    public function getZip()
    {
        return $this->object['object']['data_map']['zip']['content'];
    }

    /**
     * @return string
     */
    public function getCity()
    {
        /*
         * This is more relevant than the one that lies where all
         * the other data is. It is unknown why.
         */
        return $this->object['city'];
    }

    /**
     * @return string|null
     */
    public function getCountry()
    {
    }

    /**
     * @return float|null
     */
    public function getLatitude()
    {
        if (strpos($this->object['geo'], '#') !== false) {
            list($latitude, $_) = explode('#', $this->object['geo']);
            return $latitude;
        }
    }

    /**
     * @return float|null
     */
    public function getLongitude()
    {
        if (strpos($this->object['geo'], '#') !== false) {
            list($_, $longitude) = explode('#', $this->object['geo']);
            return $longitude;
        }
    }

    /**
     * @return array<AddressAdapter>
     */
    public function getAddresses()
    {
        $address = new AddressAdapter($this->object['object']);
        return [$address];
    }

    /**
     * @return array<CategoryAdapter>
     */
    public function getCategories()
    {
        $category = new CategoryAdapter($this->object['object']['data_map']['type_main']);
        return [$category];
    }

    /**
     * @return array<MediumAdapter>
     */
    public function getMedia()
    {
        $media = [];
        if (!is_array($this->object['object']['data_map']['gallery']['content'])) {
            return $media;
        }

        foreach ($this->object['object']['data_map']['gallery']['content'] as $image) {
            // Skip importing media records without a source uri.
            if (!empty($image['reference'])) {
                $media[] = (new MediumAdapter($image));
            }
        }
        return $media;
    }

    /**
     * @return array
     */
    public function getAttributes()
    {
        $attributes = [];

        $attributes['freeEntrance'] = $this->object['object']['data_map']['prices_free']['content'];

        if (!empty($this->object['object']['data_map']['priceinfotext']['content'])) {
            $attributes['priceInformation'] = $this->object['object']['data_map']['priceinfotext']['content'];
        }
        if (!empty($this->object['object']['data_map']['prices']['content'])) {
            $attributes['prices'] = $this->object['object']['data_map']['prices']['content'];
        }
        if (!empty($this->object['object']['data_map']['discount_card']['content'])) {
            $attributes['discountCard'] = $this->object['object']['data_map']['discount_card']['content'];
        }

        return $attributes;
    }

    /**
     * @return array
     */
    public function getFiles()
    {
        // TODO
        return [];
    }

    /**
     * @return string|null
     */
    public function getFacebookUri()
    {
        if (!is_array($this->object['object']['data_map']['facebook'])) {
            return;
        }

        $value = $this->object['object']['data_map']['facebook']['content'];
        if (empty($value) || $this->isUrlPlaceholder($value)) {
            return null;
        }

        return $value;
    }

    /**
     * @return string
     */
    public function getTwitterUri()
    {
        if (!is_array($this->object['object']['data_map']['twitter'])) {
            return;
        }

        $value = $this->object['object']['data_map']['twitter']['content'];
        if (empty($value) || $this->isUrlPlaceholder($value)) {
            return null;
        }

        return $value;
    }

    /**
     * @return string
     */
    public function getInstagramUri()
    {
        if (!is_array($this->object['object']['data_map']['instagram'])) {
            return;
        }

        $value = $this->object['object']['data_map']['instagram']['content'];
        if (empty($value) || $this->isUrlPlaceholder($value)) {
            return null;
        }

        return $value;
    }

    /**
     * @return string
     */
    public function getYoutubeUri()
    {
        if (!is_array($this->object['object']['data_map']['youtube'])) {
            return;
        }

        $value = $this->object['object']['data_map']['youtube']['content'];
        if (empty($value) || $this->isUrlPlaceholder($value)) {
            return null;
        }

        return $value;
    }

    /**
     * @return string
     */
    public function getSourceName()
    {
        return null;
    }

    /**
     * @return string|null
     */
    public function getAuthorName()
    {
        if (!empty($this->object['object']['author'])) {
            return $this->object['object']['author'];
        }
    }

    /**
     * @return string
     */
    public function getBookingUri()
    {
        // TODO
        return;
    }

    /**
     * @param string $value
     * @return bool
     */
    protected function isUrlPlaceholder($value)
    {
        return ($value == 'http://' || $value == 'https://');
    }
}
