<?php

namespace Newland\Toubiz\Api\Service\Weather\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\Weather\HourAdapterInterface;

abstract class AbstractDayAdapter
{
    /**
     * @var HourAdapterInterface[]
     */
    protected $hours = [];

    /**
     * Returns the symbol code for the data group.
     *
     * @return string
     */
    protected function getGeneralSymbol(): string
    {
        $count = [];
        foreach ($this->hours as $hour) {
            if ($hour->getTime() >= 8 && $hour->getTime() <= 18) {
                if (!array_key_exists($hour->getSymbol(), $count)) {
                    $count[$hour->getSymbol()] = 1;
                } else {
                    $count[$hour->getSymbol()]++;
                }
            }
        }

        return array_keys($count, max($count))[0];
    }

    protected function calculateMaximumTemperature(): int
    {
        $temperatures = [];
        foreach ($this->getMainHours() as $hourItem) {
            $temperatures[] = $hourItem->getMaximumTemperature();
        }

        return max($temperatures);
    }

    protected function calculateMinimumTemperature(): int
    {
        $temperatures = [];
        foreach ($this->getMainHours() as $hourItem) {
            $temperatures[] = $hourItem->getMinimumTemperature();
        }

        return max($temperatures);
    }

    abstract protected function calculateSunshineDuration(array $data): int;

    /**
     * @return HourAdapterInterface[]
     */
    abstract protected function getMainHours(): array;
}
