<?php
namespace Newland\Toubiz\Api\Service;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

/**
 * Service factory.
 *
 * Instantiates the correct service version based on the given name.
 */
class ServiceFactory
{
    /**
     * Getter for a given service.
     *
     * @api
     * @param string $name
     * @todo return annotation
     * @todo throws annotation and functionality
     */
    public static function get(string $name)
    {
        $namespaced = str_replace('/', "\\", $name);
        $className = "\\Newland\\Toubiz\\Api\\Service\\{$namespaced}Service";
        return (new $className);
    }
}
