<?php

namespace Newland\Toubiz\Api\Service\Meteotest\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\Weather\DayAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\WeatherAdapterInterface;

class WeatherAdapter implements WeatherAdapterInterface
{
    static public $dictionary = [
        'dd' => 'windDirection',
        'ff' => 'windSpeed',
        'fx' => 'maximumWindGust',
        'rr' => 'rainPrecipitation',
        'rrp' => 'rainProbability',
        'sl' => 'snowfallLine',
        'ss' => 'sunshineDuration',
        'sy' => 'symbol',
        'tn' => 'minimumTemperature',
        'tt' => 'temperature',
        'tx' => 'maximumTemperature'
    ];
    /**
     * @var DayAdapter[]
     */
    protected $days;
    /**
     * @var string
     */
    private $location;
    /**
     * @var int
     */
    private $lastUpdated;

    public function __construct(string $location, array $data)
    {
        $this->location = $location;
        $this->parseData($data);
        $this->lastUpdated = $this->getCurrentTime();
    }

    private function parseData(array $data)
    {
        $dateToPopulate = '';
        $hourRecordsOfCurrentDay = [];

        foreach ($data as $dateString => $values) {
            $itemDate = new \DateTime($dateString);
            if (!$dateToPopulate) {
                $dateToPopulate = $itemDate->format('Ymd');
            }

            if ($dateToPopulate === $itemDate->format('Ymd')) {
                $hourRecordsOfCurrentDay[$dateString] = $values;
            } else {
                $this->days[] = new DayAdapter($dateString, $hourRecordsOfCurrentDay);
                $dateToPopulate = '';
                $hourRecordsOfCurrentDay = [
                    $dateString => $values
                ];
            }
        }
    }

    /**
     * Wrap in public function for mocking.
     *
     * @return int
     */
    public function getCurrentTime(): int
    {
        return time();
    }

    public function getExternalId(): string
    {
        return $this->getLocation();
    }

    public function getLocation(): string
    {
        return $this->location;
    }

    /**
     * @return DayAdapterInterface[]
     */
    public function getForecast(): array
    {
        return $this->days;
    }

    /**
     * @return int Timestamp of latest import
     */
    public function getLastUpdated(): int
    {
        return $this->lastUpdated;
    }
}
