<?php

namespace Newland\Toubiz\Api\Service\Meteotest\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\Weather\HourAdapterInterface;

class HourAdapter implements HourAdapterInterface
{
    /**
     * @var SymbolAdapter
     */
    private $symbolAdapter;
    /**
     * @var \DateTime
     */
    private $date;
    /**
     * @var int
     */
    private $time = 0;
    /**
     * @var int
     */
    private $temperature = 0;
    /**
     * @var string
     */
    private $symbol = '';
    /**
     * @var int
     */
    private $maximumTemperature;
    /**
     * @var int
     */
    private $minimumTemperature;

    public function __construct(string $dateString, array $data)
    {
        $this->symbolAdapter = new SymbolAdapter();
        $this->date = new \DateTime($dateString);
        $this->setTimeFromDateString($dateString);
        $this->parseData($data);
    }

    private function setTimeFromDateString(string $dateString)
    {
        $date = new \DateTime($dateString);
        $this->time = (int)$date->format('G');
    }

    private function parseData(array $data)
    {
        $this->temperature = round($data['tt']);
        $this->maximumTemperature = isset($data['tn']) ? round($data['tn']) : null;
        $this->minimumTemperature = isset($data['tx']) ? round($data['tx']) : null;
        $this->symbol = $this->symbolAdapter->getClass((int)$data['sy']);
    }

    public function getTemperature(): int
    {
        return $this->temperature;
    }

    public function getSymbol(): string
    {
        return $this->symbol;
    }

    public function getExternalId(): string
    {
        return '';
    }

    /**
     * @return \DateTime
     */
    public function getDate(): \DateTime
    {
        return $this->date;
    }

    /**
     * The hour of the time in 0 - 23 format.
     *
     * @return int
     */
    public function getTime(): int
    {
        return $this->time;
    }

    public function getMinimumTemperature(): int
    {
        return $this->minimumTemperature ?? $this->temperature;
    }

    public function getMaximumTemperature(): int
    {
        return $this->maximumTemperature ?? $this->temperature;
    }
}
