<?php

namespace Newland\Toubiz\Api\Service\Meteotest\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\Weather\DayAdapterInterface;
use Newland\Toubiz\Api\ObjectAdapter\Weather\HourAdapterInterface;
use Newland\Toubiz\Api\Service\Weather\ObjectAdapter\AbstractDayAdapter;

class DayAdapter extends AbstractDayAdapter implements DayAdapterInterface
{
    /**
     * @var HourAdapter[]
     */
    protected $hours;
    /**
     * @var \DateTime
     */
    private $date;
    /**
     * @var int
     */
    private $maximumTemperature = 0;
    /**
     * @var int
     */
    private $minimumTemperature = 0;
    /**
     * @var string
     */
    private $symbol = '';
    /**
     * @var int
     */
    private $sunshineDuration = 0;

    public function __construct(string $dateString, array $data)
    {
        $this->date = new \DateTime($dateString);
        $this->parseData($data);
    }

    private function parseData($data)
    {
        foreach ($data as $dateString => $hourItem) {
            $this->hours[] = new HourAdapter($dateString, $hourItem);
        }
        $this->symbol = $this->getGeneralSymbol();
        $this->maximumTemperature = $this->calculateMaximumTemperature();
        $this->minimumTemperature = $this->calculateMinimumTemperature();
        $this->sunshineDuration = $this->calculateSunshineDuration($data);
    }

    protected function calculateSunshineDuration(array $data): int
    {
        $duration = 0;
        foreach ($data as $hourItem) {
            $duration += (int)$hourItem['ss'];
        }

        return $duration;
    }

    public function getDate(): \DateTime
    {
        return $this->date;
    }

    /**
     * @return HourAdapterInterface[]
     */
    public function getAllHours(): array
    {
        return $this->hours;
    }

    /**
     * @return HourAdapterInterface[]
     */
    public function getMainHours(): array
    {
        $mainHours = [];

        if (\count($this->hours) === 24) {
            $mainHours = [
                $this->hours[0],
                $this->hours[6],
                $this->hours[12],
                $this->hours[18],
            ];
        }

        return $mainHours;
    }

    /**
     * @return HourAdapterInterface[]
     */
    public function getMainHoursPadded(): array
    {
        return $this->getMainHours();
    }

    public function getMaximumTemperature(): int
    {
        return $this->maximumTemperature;
    }

    public function getMinimumTemperature(): int
    {
        return $this->minimumTemperature;
    }

    public function getSymbol(): string
    {
        return $this->symbol;
    }

    public function getSunshineDuration(): int
    {
        return $this->sunshineDuration;
    }

    public function getExternalId(): string
    {
        return '';
    }

    public function hasSunshineDurationData(): bool
    {
        return true;
    }
}
