<?php declare(strict_types=1);

namespace Newland\ToubizApi\Tests\Unit\Service\Tportal\ObjectAdapter;

use Newland\Toubiz\Api\Service\Tportal\ObjectAdapter\LodgingAdapter;
use Newland\Toubiz\Api\Service\Tportal\ObjectAdapter\StarRatingAdapter;
use PHPUnit\Framework\TestCase;

class StarRatingAdapterTest extends TestCase
{

    /**
     * @dataProvider provideStarClassificationStrings
     */
    public function testExtractsStarRatings($external, $expected): void
    {
        $lodging = new StarRatingAdapter(
            [
                    'twsDataClassAttribute' => [
                        'name' => 'ClassificationServiceProvider'
                    ],
                    'twsLookupValues' => [
                        'value' => $external
                    ]
            ]
        );

        $this->assertEquals($expected, $lodging->getValue());
    }

    public function provideStarClassificationStrings(): array
    {
        return [
            [ '4 Sterne Superior', 4 ],
            [ '4-Sterne Superior', 4 ],
            [ 'F***', 3 ],
            [ 'STV *** Sup.', 3 ],
            [ 'STV **** Sup.', 4 ],
            [ 'No classification', -1 ],
            [ 'Nicht klassifiziert', -1 ],
            [ 'foobar', -1 ],
            [ 2, 2 ],
            [ '4', 4 ],
            [ null, -1 ]
        ];
    }
}
