<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Tests\Unit\Exception;

use Newland\Toubiz\Api\Exception\StringCleaningException;
use PHPUnit\Framework\TestCase;

class StringCleaningExceptionTest extends TestCase
{

    public function testDumpsInvalidStringToDisk(): void
    {
        $exception = StringCleaningException::create('FOO');
        $this->assertFileExists($exception->getDumpLocation());
        $this->assertEquals('FOO', file_get_contents($exception->getDumpLocation()));
    }

    /** @dataProvider provideWeirdStrings */
    public function testCanDumpWeirdStrings(string $string): void
    {
        $exception = StringCleaningException::create($string);
        $this->assertFileExists($exception->getDumpLocation());
        $this->assertEquals($string, file_get_contents($exception->getDumpLocation()));
    }

    public function provideWeirdStrings(): array
    {
        return [
            'partial line forwards' => [ "Foo\xC2\x8BBar" ],
            'start of selected area' => [ "Foo\xC2\x86Bar" ],
            'non breaking space' => [ "Foo\xC2\xA0Bar" ],
            'private use only' => [ "Foo\xC2\x91Bar" ],
            'start guarded area' => [ "Foo\xC2\x97Bar" ],
            'vertical whitespace' => [ "Foo\vBar" ],
            'end guarded area' => [ "Foo\xC2\x97Bar" ],
            'operating system command' => [ "Foo\xC2\x9DBar" ],
            'invalid UTF8 sequence 1' => [ "Foo\xC2Bar" ],
            'invalid UTF8 sequence 2' => [ "Foo\xADBar" ],
            'invalid UTF8 sequence 3' => [ "Foo\xE2\x80Bar" ],
            'control characters 1' => [ "Foo\x10Bar" ],
            'control characters 2' => [ "Foo\x15Bar" ],
            'control characters 3' => [ "Foo\x1DBar" ],
            'control characters 4' => [ "Foo\xC2\x80Bar" ],
            'control characters 5' => [ "Foo\xC2\x8EBar" ],
            'soft hyphen' => [ "Foo\xC2\xADBar" ],
            'line separator' => [ "Foo\xE2\x80\xA8Bar" ],
            'paragraph separator character' => [ "Foo\xE2\x80\xA9Bar" ],
            'invisible separator' => [ "Foo\xE2\x81\xA3Bar" ],
            'special chars' => [ '<p>B500 Titisee- Feldberg Abzweig Lenzkirch - L4990 Lenzkirch</p> <p>47°52‘172‘‘N     8°12‘183‘‘O</p>' ]
        ];
    }

}
