<?php
namespace Newland\Toubiz\Api\Utility;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use function \Safe\preg_replace;

class UrlUtility
{
    public static function isValidUrl(string $url): bool
    {
        if (trim($url) === '') {
            return false;
        }

        return (bool) preg_match('/^https?:\/\/.+$/', $url);
    }

    public static function forceHttps(?string $url = null): ?string
    {
        if ($url === null) {
            return null;
        }

        $result = preg_replace('/^http:\/\//', 'https://', $url);
        if (is_array($result)) {
            $result = implode('', $result);
        }

        return $result;
    }

    public static function addProtocolIfMissing(string $url): string
    {
        if ((bool) preg_match('/^https?:\/\/.+$/', $url)) {
            return $url;
        }

        return 'http://' . $url;
    }
}
