<?php declare(strict_types=1);

namespace Newland\Toubiz\Sync\Neos\Tests\Unit\Service\Toubiz\Legacy\TourApiService\EventApiService;

use Neos\Flow\Tests\FunctionalTestCase;
use Newland\Toubiz\Api\Service\Toubiz\Legacy\ObjectAdapter\EventApiService\EventAdapter;

class EventAdapterTest extends FunctionalTestCase
{

    /** @dataProvider provideEventExampleData */
    public function testProvidesExternalId(string $id, array $data): void
    {
        $adapter = new EventAdapter($data);
        $this->assertEquals($id, $adapter->getExternalId());
    }

    /** @dataProvider provideEventExampleData */
    public function testMapsMedia(string $id, array $data): void
    {
        // Assumption: All test data has at least one media element in it
        $adapter = new EventAdapter($data);
        $this->assertGreaterThanOrEqual(1, \count($adapter->getMedia()));
    }


    public function testIgnoresMediaWithEmptySourceUri(): void
    {
        $adapter = new EventAdapter([
             'id_event' => 'test',
             'multimedia' => [
                 [ 'multimediaTypeID' => 'test', 'url_big' => '' ],
                 [ 'multimediaTypeID' => 'test', 'url_big' => 'https://placehold.it/500x500' ],
             ]
         ]);

        $this->assertCount(1, $adapter->getMedia());
        $this->assertEquals('https://placehold.it/500x500', $adapter->getMedia()[0]->getSourceUri());
    }

    /** @dataProvider provideEventExampleData */
    public function testMapsEventDates(string $id, array $data): void
    {
        // Assumption: All test data has at least one date
        $adapter = new EventAdapter($data);
        $this->assertGreaterThanOrEqual(1, \count($adapter->getEventDates()));
    }

    public function provideEventExampleData(): array
    {
        $dir = __DIR__ . '/../../../../../../Fixtures/Events/';
        $data = [];
        foreach (glob($dir . '*.json') as $file) {
            $id = str_replace([ $dir, '.json' ], '', $file);
            $data[$id] = [ $id, json_decode(file_get_contents($file), true) ];
        }
        return $data;
    }

    public function testProvidesSearchWords(): void
    {
        $adapter = new EventAdapter([
            'searchwords' => [
                [ 'keywordTypeID' => '72886', 'keyword' => 'foo' ],
                [ 'keywordTypeID' => '72887', 'keyword' => 'bar' ],
            ]
        ]);

        $this->assertEquals('foo bar', $adapter->getAdditionalSearchString());
    }

    public function testDoesNotProvideSearchWordsIfEmpty(): void
    {
        $adapter = new EventAdapter([ 'searchwords' => [] ]);
        $this->assertNull($adapter->getAdditionalSearchString());
    }

    public function testDoesNotProvideSearchWordsIfNonExistent(): void
    {
        $adapter = new EventAdapter([ ]);
        $this->assertNull($adapter->getAdditionalSearchString());
    }
}
