<?php
namespace Newland\Toubiz\Api\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\Service\StringCleaner;

/**
 * Abstract object adapter.
 */
abstract class AbstractObjectAdapter implements ProvidesRawJson
{
    /** @var mixed Adapted object */
    protected $object;

    /** @var StringCleaner */
    protected $stringCleaner;

    /**
     * AbstractObjectAdapter constructor.
     * @param mixed $adaptee
     * @return void
     */
    public function __construct($adaptee = null)
    {
        $this->setObject($adaptee);
        $this->stringCleaner = new StringCleaner();
    }

    /**
     * @param mixed $adaptee
     * @return void
     */
    public function setObject($adaptee)
    {
        $this->object = $adaptee;
    }

    public function getRawJson(): array
    {
        return (array) $this->object;
    }
}
