<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Service\Meteogroup\ObjectAdapters;

use Newland\Toubiz\Api\ObjectAdapter\ProvidesRawJson;
use Newland\Toubiz\Api\ObjectAdapter\WeatherAdapterInterface;

class WeatherAdapter implements WeatherAdapterInterface
{
    /** @var array */
    protected $normalized;

    public function __construct(\SimpleXMLElement $xml)
    {
        $this->normalized = $this->normalizeData($xml);
    }

    private function normalizeData(\SimpleXMLElement $xml): array
    {
        $days = [];
        foreach ($xml->children() as $category) {
            foreach ($category->children() as $value) {
                /** @var \SimpleXMLElement $category */
                /** @var \SimpleXMLElement $value */

                $type = (string) $category->attributes()->Typ;
                $date = (string) $value->attributes()->Datum;

                $days[$date] = $days[$date] ?? [ 'date' => $date ];
                $days[$date][$type] = (string) $value;
            }
        }
        return $days;
    }


    public function getExternalId(): string
    {
        return 'Meteogroup';
    }

    public function getLocation(): string
    {
        // TODO?
        return '';
    }

    public function getForecast(): array
    {
        return array_map(
            function ($item) {
                return new DayAdapter($item);
            },
            $this->normalized
        );
    }

    public function getLastUpdated(): int
    {
        return time();
    }

    public function getRawJson(): array
    {
        return $this->normalized;
    }
}
