<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Service\Toubiz\ApiV1\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\AddressAdapterInterface;

class AddressAdapter extends AbstractObjectAdapter implements AddressAdapterInterface
{
    public function getTitle(): ?string
    {
        return $this->object['name'];
    }

    public function getFirstName(): ?string
    {
        return null;
    }

    public function getLastName(): ?string
    {
        return null;
    }

    public function getStreet(): ?string
    {
        return sprintf('%s %d', $this->object['street'], $this->object['streetNumber']);
    }

    public function getZip(): ?string
    {
        return $this->object['zip'];
    }

    public function getCity(): ?string
    {
        return $this->object['city'];
    }

    public function getCountry(): ?string
    {
        return $this->object['country'];
    }

    public function getPhoneNumber(): ?string
    {
        return null;
    }

    public function getFaxNumber(): ?string
    {
        return null;
    }

    public function getEmailAddress(): ?string
    {
        return null;
    }

    public function getWebsiteAddress(): ?string
    {
        return null;
    }

    public function getLatitude(): ?float
    {
        return null;
    }

    public function getLongitude(): ?float
    {
        return null;
    }

    public function isLookup(): bool
    {
        return true;
    }

    public function getExternalId(): string
    {
        return $this->object['id'];
    }
}
