<?php
namespace Newland\Toubiz\Api\Service\Meteotest\ObjectAdapter;

/*
 * This file is part of the "toubiz-api" package.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 */

use Newland\Toubiz\Api\ObjectAdapter\Weather\HourAdapterInterface;

class HourAdapter implements HourAdapterInterface
{
    /**
     * @var SymbolAdapter
     */
    private $symbolAdapter;
    /**
     * @var \DateTime
     */
    private $date;
    /**
     * @var int
     */
    private $time = 0;
    /**
     * @var float
     */
    private $temperature = 0;
    /**
     * @var string
     */
    private $symbol = '';
    /**
     * @var float
     */
    private $maximumTemperature;
    /**
     * @var float
     */
    private $minimumTemperature;

    public function __construct(string $dateString, array $data)
    {
        $this->symbolAdapter = new SymbolAdapter();
        $this->date = new \DateTime($dateString);
        $this->setTimeFromDateString($dateString);
        $this->parseData($data);
    }

    private function setTimeFromDateString(string $dateString): void
    {
        $date = new \DateTime($dateString);
        $this->time = (int) $date->format('G');
    }

    private function parseData(array $data): void
    {
        $this->temperature = round($data['tt']);
        if (isset($data['tx'])) {
            $this->maximumTemperature = $data['tx'];
        }
        if (isset($data['tn'])) {
            $this->minimumTemperature = $data['tn'];
        }
        $this->symbol = $this->symbolAdapter->getClass((int) $data['sy']);
    }

    public function getTemperature(): float
    {
        return $this->temperature;
    }

    public function getSymbol(): string
    {
        return $this->symbol;
    }

    public function getExternalId(): string
    {
        return '';
    }

    /**
     * @return \DateTime
     */
    public function getDate(): \DateTime
    {
        return $this->date;
    }

    /**
     * The hour of the time in 0 - 23 format.
     *
     * @return int
     */
    public function getTime(): int
    {
        return $this->time;
    }

    public function getMinimumTemperature(): float
    {
        return $this->minimumTemperature ?? $this->temperature;
    }

    public function getMaximumTemperature(): float
    {
        return $this->maximumTemperature ?? $this->temperature;
    }
}
