<?php declare(strict_types=1);

namespace Newland\Toubiz\Api\Service\Toubiz\ApiV1\ObjectAdapter;

use Newland\Toubiz\Api\ObjectAdapter\AbstractObjectAdapter;
use Newland\Toubiz\Api\ObjectAdapter\Concern\MediumConstants;
use Newland\Toubiz\Api\ObjectAdapter\MediumAdapterInterface;

class MediumAdapter extends AbstractObjectAdapter implements MediumAdapterInterface
{

    public function getSourceUri(): string
    {
        return $this->object['url'];
    }

    public function getTitle(): ?string
    {
        return $this->object['name'];
    }

    public function getCopyright(): ?string
    {
        return $this->object['copyright'];
    }

    public function getType(): string
    {
        return MediumConstants::TYPE_IMAGE;
    }

    public function getExternalId(): string
    {
        return $this->object['id'];
    }
}
